<?php $__env->startSection('title'); ?>
    <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0 text-dark"><?php echo e($title); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">All <?php echo e($title); ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 col-12">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">All <?php echo e($title); ?></h3>
                        </div>
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th>User</th>
                                        <th>Amount</th>
                                        <th>Charge</th>
                                        <th>Type</th>
                                        <th>Account</th>
                                        <th>Admin Fee</th>
                                        <th>Date Time</th>
                                        <th>Status</th>
                                        <th width="15%">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e(user_name($data->user_id)); ?><br><small><?php echo e(user_code($data->user_id)); ?></small></td>
                                            <td><?php echo e($data->amount - $data->charge); ?>$</td>
                                            <td><?php echo e($data->charge); ?> $</td>
                                            <td><?php echo e($data->account_type); ?></td>
                                            <td><?php echo e($data->account_no); ?></td>
                                            <td><?php echo e($data->admin_fee); ?>%</td>
                                            <td>
                                                <?php echo e(\Carbon\Carbon::parse($data->created_at)->format('j M Y g:i A')); ?>

                                            </td>
                                            <td>
                                                <?php if($data->approval == 0): ?>
                                                    <span class="badge bg-warning">Pending</span>
                                                <?php elseif($data->approval == 1): ?>
                                                    <span class="badge bg-success p-2">Paid</span>
                                                <?php else: ?>
                                                    <span class="badge bg-danger p-2">Rejected</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($data->approval == 0): ?>
                                                    <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal" data-target="#edit_<?php echo e($data->id); ?>">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                <?php endif; ?>
                                                <a href="<?php echo e(route('admin.withdraw-request-delete', $data->id)); ?>" onclick="return confirm(' You want to delete?');" class="btn btn-sm btn-danger">Delete</a>
                                            </td>
                                        </tr>
                                        <div class="modal fade" id="edit_<?php echo e($data->id); ?>" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <form action="<?php echo e(route('admin.withdraw-request-approved', $data->id)); ?>" method="POST" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <span>Update Status</span>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="form-group col-lg-12 col-md-12 col-12">
                                                                <label for="status">Status</label>
                                                                <select class="form-control" name="approval" id="approval">
                                                                    <option value="0" <?php if($data->approval == 0): ?> selected <?php endif; ?>>Pending</option>
                                                                    <option value="1" <?php if($data->approval == 1): ?> selected <?php endif; ?>>Approved</option>
                                                                    <option value="2" <?php if($data->approval == 2): ?> selected <?php endif; ?>>Rejected</option>
                                                                </select>
                                                            </div>
                                                            <div class="form-group col-lg-12 col-md-12 col-12">
                                                                <label for="reason">Reason</label>
                                                                <textarea class="form-control" name="reason" id="reason" cols="30" rows="3"><?php echo e($data->reason); ?></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                            <button type="submit" class="btn btn-primary">Update</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>

    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
                "pageLength": 300,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });

        function depositApproved(id) {
            if (confirm("Are you sure?")) {
                document.getElementById('deposit-approved-'+id).submit();
            }
            return false;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/bestleea/public_html/resources/views/backend/pages/system-setting/withdraw.blade.php ENDPATH**/ ?>